# 帳票設計書 18-CodeQuality Reports

## 概要

本ドキュメントは、GitLabにおけるCodeQuality Reports機能の帳票設計書である。コード品質レポートをJSON形式で生成する機能について、出力形式、データ構造、処理フローを定義する。

### 本帳票の処理概要

CodeQuality Reportsは、CIパイプラインで実行されたコード品質チェックの結果を比較・分析するレポートである。Code Climate、ESLint、RuboCop等の静的解析ツールの出力を解析し、ベースパイプラインとヘッドパイプラインの結果を比較して、新規問題、解決済み問題、既存問題を分類して表示する。

**業務上の目的・背景**：コード品質を継続的に監視し、技術的負債の増加を防ぐ必要がある。このレポートにより、コード変更がコード品質に与える影響を把握し、問題を早期に発見・修正することができる。コードレビューの効率化と品質ゲートの自動化を支援する。

**帳票の利用シーン**：Merge Requestのレビュー時にコード品質への影響を確認する場合、コード品質改善の進捗を追跡する場合、技術的負債の管理・可視化を行う場合などで利用される。

**主要な出力内容**：
1. 全体ステータス
2. サマリー（総数、解決数、エラー数）
3. 新規エラー一覧
4. 解決済みエラー一覧
5. 既存エラー一覧
6. 各エラーの詳細（重大度、説明、ファイル位置、fingerprint）

**帳票の出力タイミング**：Merge Request画面のコード品質ウィジェットで表示される。パイプライン完了後にデータが生成される。

**帳票の利用者**：開発者、コードレビュアー、テックリード、QAエンジニア

## 帳票種別

JSON出力（APIレスポンス）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Merge Request詳細 | `/:namespace/:project/-/merge_requests/:id` | コード品質ウィジェット表示 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（APIレスポンス） |
| 出力方法 | API経由でJSON返却 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

JSONレスポンス構造

```json
{
  "status": "success/failed",
  "new_errors": [
    {
      "description": "問題の説明",
      "severity": "major/minor/info/critical/blocker",
      "file_path": "path/to/file.rb",
      "line": 42,
      "fingerprint": "abc123..."
    }
  ],
  "resolved_errors": [...],
  "existing_errors": [...],
  "summary": {
    "total": 10,
    "resolved": 3,
    "errored": 5
  }
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | status | 全体ステータス | 計算値 | 文字列 |

### 明細部（summary）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | total | 総エラー数 | total_count | 数値 |
| 2 | resolved | 解決済みエラー数 | resolved_count | 数値 |
| 3 | errored | 現在のエラー数 | errors_count | 数値 |

### 明細部（エラー配列）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | description | 問題の説明 | degradation.description | 文字列 |
| 2 | severity | 重大度 | degradation.severity | 文字列 |
| 3 | file_path | ファイルパス | degradation.file_path | 文字列 |
| 4 | line | 行番号 | degradation.line | 数値 |
| 5 | fingerprint | 一意識別子 | degradation.fingerprint | 文字列 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロジェクトアクセス権 | プロジェクトの読み取り権限 | Yes |
| パイプライン完了 | コード品質レポートアーティファクト生成済み | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 重大度 | 降順（critical > major > minor > info） |
| 2 | ファイルパス | 昇順 |

### 改ページ条件

N/A（JSON出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ci_pipelines | パイプライン情報 | 主テーブル |
| ci_builds | ビルド情報 | pipeline_id = ci_pipelines.id |
| ci_job_artifacts | コード品質レポートアーティファクト | job_id = ci_builds.id |

### テーブル別参照項目詳細

#### ci_job_artifacts

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| file | コード品質レポートファイル | file_type = :codequality | Code Climate形式JSON |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| total_count | new_errors + resolved_errors + existing_errors | - | - |
| resolved_count | resolved_errors.count | - | base有り → head無し |
| errors_count | new_errors + existing_errors | - | 現在のエラー数 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[コード品質レポート要求] --> B[base/headパイプライン取得]
    B --> C[コード品質レポート取得]
    C --> D[CodequalityReportsComparer生成]
    D --> E[CodequalityReportsComparerSerializer変換]
    E --> F[JSON返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パース中 | レポート解析中 | status: parsing | 再度リクエスト |
| データなし | コード品質レポートなし | 空レスポンス | コード品質ジョブ設定を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | エラー数に依存（〜数千件） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 特になし |

## セキュリティ考慮事項

- プロジェクトのアクセス権限に基づいてレポートを表示
- エラーメッセージにコードパスが含まれるため、権限チェックが必須

## 備考

- Code Climate形式のJSON出力に対応
- fingerprintによりエラーの同一性を判定
- 重大度レベル：blocker > critical > major > minor > info

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コード品質レポートのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | codequality_reports_comparer_entity.rb | `app/serializers/codequality_reports_comparer_entity.rb` | レスポンス構造。status, new_errors, resolved_errors, existing_errors, summaryを公開 |
| 1-2 | codequality_degradation_entity.rb | `app/serializers/codequality_degradation_entity.rb` | エラー詳細。description, severity, file_path, line, fingerprintを公開 |

**読解のコツ**: Grape::Entityを使用したシリアライザ。CodequalityDegradationEntityで個別エラーの構造を定義。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | codequality_reports_comparer_serializer.rb | `app/serializers/codequality_reports_comparer_serializer.rb` | シリアライザ本体。CodequalityReportsComparerEntityを使用 |

**主要処理フロー**:
1. **4行目**: entity CodequalityReportsComparerEntity - エンティティクラスの指定

#### Step 3: パイプラインのコード品質レポート取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pipeline.rb | `app/models/ci/pipeline.rb` | codequality_reportsメソッドの実装（行1348-1354） |

**主要処理フロー**:
- **1348-1354行目**: codequality_reportsメソッド - CodequalityReportsオブジェクトを生成し、各ビルドからレポートを収集

### プログラム呼び出し階層図

```
Pipeline#codequality_reports
    │
    └─ CodequalityReports.new
           │
           └─ latest_report_builds_in_self_and_project_descendants(Ci::JobArtifact.of_report_type(:codequality))
                  │
                  └─ build.collect_codequality_reports!
                         │
                         └─ CodequalityReports
                                ├─ new_errors
                                ├─ resolved_errors
                                └─ existing_errors
                                       ↓
                         CodequalityReportsComparerSerializer
                                       ↓
                         CodequalityReportsComparerEntity
                                ├─ status
                                ├─ new_errors (using CodequalityDegradationEntity)
                                ├─ resolved_errors
                                ├─ existing_errors
                                └─ summary
                                       ↓
                                JSON レスポンス
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ci_job_artifacts ─────────▶ Pipeline#codequality_reports ───▶ CodequalityReports
(Code Climate JSON)            │                                     │
                               └─ collect_codequality_reports!       │
                                                                     ↓
                                                       CodequalityReportsComparer
base_pipeline ──────────────────────────────────────▶        │
                                                             ├─ new_errors
head_pipeline ──────────────────────────────────────▶        ├─ resolved_errors
                                                             └─ existing_errors
                                                                     ↓
                                                  CodequalityReportsComparerSerializer
                                                                     ↓
                                                              JSON レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| codequality_reports_comparer_serializer.rb | `app/serializers/codequality_reports_comparer_serializer.rb` | ソース | シリアライザ |
| codequality_reports_comparer_entity.rb | `app/serializers/codequality_reports_comparer_entity.rb` | ソース | エンティティ |
| codequality_degradation_entity.rb | `app/serializers/codequality_degradation_entity.rb` | ソース | エラーエンティティ |
| pipeline.rb | `app/models/ci/pipeline.rb` | ソース | codequality_reportsメソッド |
| codequality_reports.rb | `lib/gitlab/ci/reports/codequality_reports.rb` | ソース | レポートモデル |
| codequality_reports_comparer.rb | `lib/gitlab/ci/reports/codequality_reports_comparer.rb` | ソース | 比較ロジック |
